<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Traits;

use Erlage\Photogram\Constants\SystemConstants;

trait TraitComplaintValidatorDTO
{
    /*
    |--------------------------------------------------------------------------
    | we provide a dummy validator & a dummy transformer for all DTO subclasses.
    |
    | subclasses i.e concrete DTO objects, can use these implementations to comply
    | with DTO interface or 
    | 
    | they can create their own implementation if they want to enforce validation 
    | and/or transformation logic
    |--------------------------------------------------------------------------
    */

    /**
     * @param object $data  
     */
    public static function validate($data): string
    {
        return SystemConstants::OK;
    }
}
